// ProductDlg.cpp : implementation file
//

#include "stdafx.h"
#include "FKAttendOcxSample.h"
#include "ProductDlg.h"

#include "MainDlg.h"
#include "PreDefine.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CProductDlg dialog
extern CMainDlg m_MainDlg;
extern CString ReturnResultPrint(long anResultCode);
extern long gnCommHandleIndex;


CProductDlg::CProductDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CProductDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CProductDlg)
	m_strBackup = _T("");
	m_strProductCode = _T("");
	m_strSerial = _T("");
	m_strMessage = _T("Message");
	//}}AFX_DATA_INIT
}


void CProductDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CProductDlg)
	DDX_Control(pDX, IDB_GET, m_cmdGet);
	DDX_Text(pDX, IDE_BACKUP, m_strBackup);
	DDX_Text(pDX, IDE_PRODUCTCODE, m_strProductCode);
	DDX_Text(pDX, IDE_SERIAL, m_strSerial);
	DDX_Text(pDX, IDT_MESSAGE, m_strMessage);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CProductDlg, CDialog)
	//{{AFX_MSG_MAP(CProductDlg)
	ON_BN_CLICKED(IDB_GET, OnGet)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CProductDlg message handlers

void CProductDlg::OnGet() 
{
	// TODO: Add your control notification handler code here
	CString vstrData;
    long vnResultCode;

    m_cmdGet.EnableWindow(false);
    m_strSerial= "";
    m_strBackup = "";
    m_strProductCode = "";
    m_strMessage = "Waiting...";
	UpdateData(false);

    vnResultCode = m_MainDlg.m_ctrlFkattend.EnableDevice( 0);
    if(vnResultCode != RUN_SUCCESS)
	{
        m_strMessage = gstrNoDevice;
        m_cmdGet.EnableWindow(true);
        goto END;
    }
	
    vnResultCode = FuncGetProductData(PRODUCT_SERIALNUMBER, vstrData);
    if(vnResultCode == RUN_SUCCESS)
	{
        m_strSerial.Format("%s", vstrData);	
        vnResultCode = FuncGetProductData(PRODUCT_BACKUPNUMBER, vstrData);
        if(vnResultCode == RUN_SUCCESS)
		{
            m_strBackup.Format("%s", vstrData);			
            vnResultCode = FuncGetProductData(PRODUCT_CODE, vstrData);
            if(vnResultCode == RUN_SUCCESS)
                m_strProductCode.Format("%s", vstrData);
        }
    }

    if(vnResultCode == RUN_SUCCESS)
        m_strMessage = "GetProductData OK";    

END:
    m_MainDlg.m_ctrlFkattend.EnableDevice( 1);
    m_cmdGet.EnableWindow(true);
	UpdateData(false);
}

BOOL CProductDlg::DestroyWindow() 
{
	// TODO: Add your specialized code here and/or call the base class
	::ShowWindow(AfxGetApp()->GetMainWnd()->m_hWnd,SW_SHOW);
	return CDialog::DestroyWindow();
}

long CProductDlg::FuncGetProductData(long anIndex, CString& astrItem)
{
	long vRet=-1;
	BSTR vStrTemp=NULL;
    CString vstrData;

	vstrData.Empty();
    vRet = m_MainDlg.m_ctrlFkattend.GetProductData(anIndex, &vStrTemp);
    if(vRet != RUN_SUCCESS)
	{
        m_strMessage = ReturnResultPrint(vRet);
        return vRet;
    }	
	vstrData=vStrTemp;
	vstrData.TrimLeft();
	vstrData.TrimRight();
	astrItem.Format("%s",vstrData);
	return vRet;
}
